# NeurIPS_2022_Power_and_limitation_of_native_QNN

This code is for our NeurIPS 2022 paper "Power and Limitations of Single-Qubit Native Quantum Neural Networks".

## Environments

This project requires PaddlePaddle 2.1.2+ and PaddleQuantum 2.1.3 (Since the latest version of PaddleQuantum has been updated to 2.2.0, you need to download the corresponding version from https://github.com/PaddlePaddle/Quantum/releases).

## Power

- ``nativeQNNU3.py`` represents a single-qubit native QNN with RZ gate as the encoding block and U3 gate as the trainable block.
- ``nativeQNNYZY.py`` represents a single-qubit native QNN with RZ gate as the encoding block and RY gate as the trainable block.
- ``one-qubit-approximation.ipynb`` includes experiments on function approximation and periodic extrapolation on paper.

## Limitation

- ``QNN_model.py`` constructs the general model of native QNN. By calling the module, the user can verify the limitations of the single-bit model.
- ``Himmelblau.py``: Fit a bivariate function using a single-qubit QNN.

## Extension

### Approximation

- ``QNN_model.py``: the general model of native QNN. By calling the module, the user can use the multi-qubit extension strategy.
- ``Himmelblau.py``: Fit a bivariate function using a two-qubit parallel-entanglement QNN and two-qubit universal trainable block QNN separately.

### Classification

To demonstrate the potential of native QNN, we perform classification tasks on three public datasets: Breast Cancer, Iris, and HTRU2. The model obtains high classification accuracy in these datasets.

- ``QNN_model.py``: the general model of native QNN.
- ``BreastCancer.py``: Use the model to do classification experiments on the Breast Cancer dataset
- ``HTRU2.py``: Use the model to do classification experiments on the HTRU2 dataset
- ``Iris.py``: Use the model to do classification experiments on the Iris dataset